% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDEE2.R
\docType{package}
\name{getDEE2}
\alias{getDEE2}
\title{getDEE2: Programmatic access to the DEE2 RNA expression dataset}
\usage{
getDEE2(
  species,
  SRRvec,
  counts = "GeneCounts",
  metadata = NULL,
  outfile = NULL,
  legacy = FALSE,
  baseURL = "http://dee2.io/cgi-bin/request.sh?",
  ...
)
}
\arguments{
\item{species}{A character string matching the species of interest.}

\item{SRRvec}{A character string or vector of SRA run accession numbers.}

\item{counts}{A string, either 'GeneCounts', 'TxCounts' or 'Tx2Gene'.
When 'GeneCounts' is specified, STAR gene level counts are returned.
When 'TxCounts' is specified, kallisto transcript counts are returned.
When 'Tx2Gene' is specified, kallisto counts aggregated (by sum) on gene
are returned. If left blank, "GeneCounts" will be fetched.}

\item{metadata}{(Optional) name of R object for the meta data. Providing
the metadata will speed up performance if multiple queries are made in a
session. If left blank, the metadata will be fetched once again.}

\item{outfile}{An optional file name for the downloaded dataset.}

\item{legacy}{Whether data should be returned in the legacy (list) format.
Default is FALSE. Leave this FALSE if you want to receive data as
Summarized experiment.}

\item{baseURL}{The base URL of the service. Leave this as the default URL
unless you want to download from a 3rd party mirror.}

\item{...}{Additional parameters to be passed to download.file.}
}
\value{
a SummarizedExperiment object.
}
\description{
Digital Expression Explorer 2 (or DEE2 for short) is a repository of
processed RNA-seq data in the form of counts. It was designed so that
researchers could undertake re-analysis and meta-analysis of published
RNA-seq studies quickly and easily. This package provides an R interface
to access these expression data. More information about the DEE2 project
can be found at the project homepage (http://dee2.io) and main publication
(https://doi.org/10.1093/gigascience/giz022).

The getDEE2 function fetches gene expression data from the DEE2 database 
of RNA sequencing data and returns it as a SummarizedExperiment object.
}
\examples{
# Example workflow
# Fetch metadata
mdat <- getDEE2Metadata("celegans")
# filter metadata for SRA project SRP009256
mdat1 <- mdat[which(mdat$SRP_accession \%in\% "SRP009256"),]
# create a vector of SRA run accessions to fetch
SRRvec <- as.vector(mdat1$SRR_accession)
# obtain the data as a SummarizedExperiment
x <- getDEE2("celegans",SRRvec,metadata=mdat,counts="GeneCounts")
# Next, downstream analysis with your favourite Bioconductor tools :)
x<-getDEE2("ecoli",c("SRR1613487","SRR1613488"))
}
\keyword{DEE2}
\keyword{RNA-seq}
\keyword{database}
