% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{makeCollectionIDs}
\alias{makeCollectionIDs}
\title{Creates a collection label for each pathway.}
\usage{
makeCollectionIDs(sets)
}
\arguments{
\item{sets}{A pathway database in the same format as output by
\code{importMSigDB.xml}.}
}
\value{
A vector of identifiers, one per pathway, with the format:
    "category_subcategory".
}
\description{
Given a database, uses "category" and "subcategory" entries to
create a vector of collection identifiers. Useful to extract a
collection from a database.
}
\examples{
db <- loadSamplePWS()
ids <- makeCollectionIDs(db)

unique(ids)
## [1] "c3_TFT" "c3_MIR" "c4_CGN"

db <- db[ids=="c3_MIR"]

length(db)
## [1] 10

}
\seealso{
importMSigDB.xml
}
