% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{gene2pathways}
\alias{gene2pathways}
\title{Finds pathways including a given gene.}
\usage{
gene2pathways(rp, genes, and = TRUE)
}
\arguments{
\item{rp}{A repository created by \code{\link{createRepository}}.}

\item{genes}{A vector of gene identifiers of the same type as that
used to create the repository.}

\item{and}{If set to TRUE (default), will return sets containing
all of \code{genes}. Otherwise will return the sets containing
any of \code{genes}.}
}
\value{
A database of pathways suitable as input to
    \code{\link{PathSEA}}.
}
\description{
Given a gene, find the set of pathways that involve it in each
collection of the repository. This can be used to define a set of
pathways for the \code{\link{PathSEA}}.
}
\examples{
db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)

## Finding all pathways containing "FAM126A":
subpw <- gene2pathways(rp, "FAM126A")

print(names(subpw))

unlink(repo_path, TRUE)

}
\seealso{
createRepository, PathSEA
}
