% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAnnotate.R
\docType{methods}
\name{heatTargetAnnotation}
\alias{heatTargetAnnotation}
\alias{plotGeneAnnotation}
\title{Plots the percentage of overlapping intervals with genomic features in a heatmap}
\usage{
heatTargetAnnotation(l, cluster = FALSE, col = c("white", "blue"),
  precedence = FALSE, plot = TRUE)
}
\arguments{
\item{l}{a \code{list} of  \code{AnnotationByFeature} objects. This 
could be returned by \code{\link{annotateWithFeatures}} function.}

\item{cluster}{TRUE/FALSE. If TRUE the heatmap is going to be clustered 
using a default hierarchical clustering scheme.}

\item{col}{a vector of two colors that will be used for interpolation. 
The first color is the lowest one, the second is the highest one}

\item{precedence}{TRUE|FALSE. If TRUE the precedence of annotation 
features will be used when plotting. The precedence will be taken
from the GRangesList used as annotation. The first GRanges will be 
treated as most important, and the second as the second most important
and so on. Such that, if an interval overlaps with features on that 
is part of the first GRanges object in the annotation GRangesList,
the rest of its overlaps with other elements in the annotation 
GRangesList will be ignored. This feature is important to have if 
the user desires that percentage of overlaps adds up to 100. This is
only possible when the annotation features are non-overlaping with
eachother or there is a hierarchy/precedence among them such as 
(with promoter>exon>intron precedence). In this case, anything that
overlaps with a promoter annotation will only be counted as promoter
even if it overlaps with exons or introns.}

\item{plot}{If FALSE, does not plot the heatmap just returns the matrix
used to make the heatmap}
}
\value{
returns the matrix used to make the heatmap when plot FALSE, 
otherwise returns ggplot2 object which can be modified further.
}
\description{
This function plots a heatmap for percentage of overlapping ranges 
with provided genomic features. The input object is a list of 
\code{AnnotationByFeature} objects, which contains necessary information
about overlap statistics to make the plot.
}
\examples{

library(GenomicRanges)
data(cage)
data(cpgi)
cage$tpm=NULL
gl = GRangesList(cage=cage, cpgi=cpgi)

bed.file = system.file("extdata/chr21.refseq.hg19.bed", package = "genomation")
gene.parts = readTranscriptFeatures(bed.file)
annot = annotateWithFeatures(gl, gene.parts, intersect.chr=TRUE)

            
\donttest{  
heatTargetAnnotation(annot)
}

}
\seealso{
see  \code{\link{getMembers}}, 
           \code{\link{annotateWithFeatures}}
}
