% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMatrix.R
\name{heatMeta}
\alias{heatMeta}
\title{Heatmap for meta-region profiles}
\usage{
heatMeta(mat, centralTend = "mean", profile.names = NULL, xcoords = NULL,
  col = NULL, meta.rescale = FALSE, winsorize = c(0, 100),
  legend.name = NULL, cex.legend = 1, xlab = NULL, main = "",
  cex.lab = 1, cex.axis = 1)
}
\arguments{
\item{mat}{\code{ScoreMatrix} or \code{ScoreMatrixList} to be plotted}

\item{centralTend}{a character that determines central tendency of meta-profile(s). 
It takes "mean" (default) or "median".}

\item{profile.names}{a character vector for names of profiles. If NULL, 
the names
will be taken from names(mat) if mat is a 
\code{ScoreMatrixList} object.}

\item{xcoords}{a vector of numbers showing relative positions of the bases or 
windows. It must match the number of columns in the \code{ScoreMatrix}
For example: if there are 2001 elements in the matrices which
are base-pair resolution 
and they are centered around an anchor point like TSS, the xcoords
argument should be -1000:1000. This argument is used to plot
accurate x-axis labels for the plots.If NULL it will be equal
to 1:ncol(mat).}

\item{col}{a vector of color pallete. 
color scheme to be used. If NULL, a version of jet colors will be
    used.}

\item{meta.rescale}{if TRUE meta-region profiles are scaled to 0 to 1 range by
subracting the min from profiles and dividing them by 
max-min.}

\item{winsorize}{Numeric vector of two, defaults to c(0,100). This vector 
determines the upper and lower percentile values to limit the 
extreme values. For example, c(0,99) will limit the values to
only 99th percentile, everything above the 99 percentile will 
be equalized to the value of 99th percentile. This is useful 
for visualization of matrices that have outliers.}

\item{legend.name}{a character label plotted next to the legend}

\item{cex.legend}{A numerical value giving the amount by which 
legend axis marks should be magnified relative to the default}

\item{xlab}{label a character string for x-axis}

\item{main}{a character string for the plot title}

\item{cex.lab}{A numerical value giving the amount by which 
axis labels (including 'legend.name') 
should be magnified relative to the default.}

\item{cex.axis}{A numerical value giving the amount by which 
axis marks should be magnified relative to the default}
}
\value{
returns meta-profile matrix invisibly.
}
\description{
Function calculates meta-profile(s) from a ScoreMatrix or a ScoreMatrixList, then
produces a heatmap or a set of stacked heatmaps for meta-region profiles
}
\examples{
 data(cage)
 data(promoters)
 scores1=ScoreMatrix(target=cage,windows=promoters,strand.aware=TRUE)
 data(cpgi)
 scores2=ScoreMatrix(target=cpgi,windows=promoters,strand.aware=TRUE)

 x=new("ScoreMatrixList",list(scores1,scores2))
 \donttest{
 heatMeta(mat=x,legend.name="fg",cex.legend=0.8,main="fdf",cex.lab=6,
          cex.axis=0.9)
 }
}
