% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAnnotate.R
\docType{methods}
\name{getTargetAnnotationStats}
\alias{getTargetAnnotationStats}
\alias{getTargetAnnotationStats,AnnotationByFeature-method}
\title{Get the percentage of target features overlapping with annotation from AnnotationByFeature}
\usage{
getTargetAnnotationStats(x,percentage=TRUE,precedence=TRUE)

\S4method{getTargetAnnotationStats}{AnnotationByFeature}(x, percentage = TRUE,
  precedence = TRUE)
}
\arguments{
\item{x}{a \code{AnnotationByFeature}  object}

\item{percentage}{TRUE|FALSE. If TRUE percentage of target 
features will be returned. If FALSE, 
number of target features will be returned}

\item{precedence}{TRUE|FALSE. If TRUE there will be a hierachy of annotation 
                  features when calculating numbers 
                  (with promoter>exon>intron precedence)
                  
That means if a feature overlaps with a promoter it will be counted as 
promoter overlapping only, or if it is overlapping with a an exon 
but not a promoter, #' it will be counted as exon overlapping only whether or
 not it overlaps with an intron.}
}
\value{
a vector of percentages or counts showing quantity of target features
        overlapping with annotation
}
\description{
This function retrieves percentage/number of target features 
overlapping with annotation
}
\examples{
data(cage)
bed.file=system.file("extdata/chr21.refseq.hg19.bed", package = "genomation")
gene.parts = readTranscriptFeatures(bed.file)
cage.annot=annotateWithGeneParts(cage, gene.parts, intersect.chr=TRUE)
getTargetAnnotationStats(cage.annot)

}
