% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAnnotate.R
\docType{methods}
\name{annotateWithFeatures}
\alias{annotateWithFeatures}
\alias{annotateWithFeatures,GRanges,GRangesList-method}
\alias{annotateWithFeatures,GRangesList,GRangesList-method}
\title{Annotate given ranges with genomic features}
\usage{
annotateWithFeatures(target, features, strand.aware = FALSE,
  intersect.chr = FALSE)

\S4method{annotateWithFeatures}{GRanges,GRangesList}(target, features,
  strand.aware = FALSE, intersect.chr = FALSE)

\S4method{annotateWithFeatures}{GRangesList,GRangesList}(target, features,
  strand.aware = FALSE, intersect.chr = FALSE)
}
\arguments{
\item{target}{GRanges or GRangesList object storing chromosome locations to be 
annotated (e.g. chipseq peaks)}

\item{features}{a named GRangesList object containing GRanges objects different set
of features. The function calculates percent overlaps with and without
precendence at the same time. The order of objects in GRangesList
defines their precedence. If a range in \code{target} overlaps with
a more precedent range in an element of \code{features}, the other 
overlaps from other less precedent elments will be discarded. This is
useful for getting piecharts where percentages should add up to 100.}

\item{strand.aware}{if set to TRUE, annotation features and target features will 
be overlapped based on strand (def:FALSE)}

\item{intersect.chr}{logical value, whether to select only chromosomes 
that are common to feature and target. FALSE by default}
}
\value{
returns an \code{AnnotationByFeature} object or if target is 
        a GRangesList, a list of \code{AnnotationByFeature} objects.
}
\description{
The function annotates a target GRangesList or GRanges object as overlapping
or not with 
the elements of a named GRangesList. This is useful to annotate your regions
of interest with genomic features with arbitrary categories such as repeat
classes or families, or output from genome segmentation alogorithms such
as chromHMM.
}
\examples{
library(GenomicRanges)
data(cage)
data(cpgi)
cage$tpm=NULL
gl = GRangesList(cage=cage, cpgi=cpgi)

bed.file = system.file("extdata/chr21.refseq.hg19.bed", package = "genomation")
gene.parts = readTranscriptFeatures(bed.file)
annot = annotateWithFeatures(gl, gene.parts, intersect.chr=TRUE)

}
\seealso{
see  \code{\link{getMembers}}, 
           \code{\link{heatTargetAnnotation}}, 
           \code{\link{plotTargetAnnotation}}
}
