% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomation-classes.R
\docType{class}
\name{ScoreMatrix-class}
\alias{ScoreMatrix-class}
\title{An S4 class for storing \code{ScoreMatrix} function results}
\description{
The resulting object is an extension of a \code{matrix} object, and stores values (typically genome-wide scores) for a predefined set of regions
Each row on the ScoreMatrix is a predefined region (Ex: CpG islands, promoters) and columns are values across those regions.
}
\section{Constructors}{

see \code{\link{ScoreMatrix}}
}

\section{Coercion}{

as(from, "matrix"): Creates a matrix from \code{ScoreMatrix} object. You can also use S3Part() function to extract the matrix from \code{ScoreMatrix} object.
}

\section{Subsetting}{

In the code snippets below, x is a ScoreMatrix object.
\code{'x[i,j]'}: Get or set elements from row \code{i} and column \code{j} and return a subset ScoreMatrix object.
}

\seealso{
\code{\link{ScoreMatrix}}
}
