% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovcYoshihara.R
\name{ovcYoshihara}
\alias{ovcYoshihara}
\title{Function to compute the subtype scores and risk classifications for
the prognostic signature published by Yoshihara et al.}
\usage{
ovcYoshihara(data, annot, hgs,
  gmap = c("entrezgene", "ensembl_gene_id", "hgnc_symbol", "unigene", "refseq_mrna"),
  do.mapping = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in
columns, dimnames being properly defined.}

\item{annot}{Matrix of annotations with one column named as gmap, dimnames
being properly defined.}

\item{hgs}{vector of booleans with TRUE represents the ovarian cancer
patients who have a high grade, late stage, serous tumor, FALSE otherwise.
This is particularly important for properly rescaling the data. If hgs is
missing, all the patients will be used to rescale the subtype score.}

\item{gmap}{character string containing the biomaRt attribute to use for
mapping if do.mapping=TRUE}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be
performed (in case of ambiguities, the most variant probe is kept for
each gene), FALSE otherwise.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item score: Continuous signature scores.
\item risk: Binary risk classification, 1 being high risk and 0 being low risk.
\item mapping: Mapping used if necessary.
\item probe: If mapping is performed, this matrix contains the correspondence
between the gene list (aka signature) and gene expression data.
}
}
\description{
This function computes subtype scores and risk classifications from gene
expression values following the algorithm developed by Yoshihara et al,
for prognosis in ovarian cancer.
}
\examples{
# load the ovcYoshihara signature
data(sigOvcYoshihara)
# load NKI dataset
data(nkis)
colnames(annot.nkis)[is.element(colnames(annot.nkis), "EntrezGene.ID")] <- "entrezgene"
# compute relapse score
ovcYoshihara.nkis <- ovcYoshihara(data=data.nkis,
  annot=annot.nkis, gmap="entrezgene", do.mapping=TRUE)
table(ovcYoshihara.nkis$risk)

}
\references{
Yoshihara K, Tajima A, Yahata T, Kodama S, Fujiwara H, Suzuki M, Onishi Y,
Hatae M, Sueyoshi K, Fujiwara H, Kudo, Yoshiki, Kotera K, Masuzaki H,
Tashiro H, Katabuchi H, Inoue I, Tanaka K (2010) "Gene expression profile
for predicting survival in advanced-stage serous ovarian cancer across two
independent datasets", PloS one, 5(3):e9615.
}
\seealso{
\link{sigOvcYoshihara}
}
