% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_create_input.R
\name{gemini_create_input}
\alias{gemini_create_input}
\title{gemini_create_input}
\usage{
gemini_create_input(
  counts.matrix,
  sample.replicate.annotation = NULL,
  guide.annotation = NULL,
  samplesAreColumns = TRUE,
  sample.column.name = "samplename",
  gene.column.names = NULL,
  ETP.column = 1,
  LTP.column = NULL,
  verbose = FALSE
)
}
\arguments{
\item{counts.matrix}{a matrix of counts with rownames corresponding to features (e.g. guides) and colnames corresponding to samples.}

\item{sample.replicate.annotation}{a data.frame of annotations for each sample/replicate pair.
Note that at least one column in \code{sample.replicate.annotation} must correspond to the colnames of \code{counts.matrix} (see Details) (default = NULL)}

\item{guide.annotation}{a data.frame of annotations for each guide.  Note that at least one column in \code{guide.annotation} must correspond to the rownames of counts.matrix (default = NULL)}

\item{samplesAreColumns}{a logical indicating if samples are on the columns or rows of counts.matrix. (default = TRUE)}

\item{sample.column.name}{a character or integer indicating which column of \code{sample.replicate.annotation} describes the samples.}

\item{gene.column.names}{a character or integer vector of length(2) indicating which columns of \code{guide.annotation} describe the genes being targeted.}

\item{ETP.column}{a character or integer vector indicating which column(s) of \code{counts.matrix} contain the early time-point(s) of the screen (i.e. pDNA, early sequencing, etc.).  Defaults to the first column.}

\item{LTP.column}{a character or integer vector indicating which column(s) is the later time-point of the screen (i.e. day21, post-treatment, etc.).  Defaults to \code{(1:ncol(counts.matrix))[-ETP.column]}, or all other columns except for those specified by \code{ETP.column}.}

\item{verbose}{Verbosity (default FALSE)}
}
\value{
a gemini.input object
}
\description{
Creates a gemini.input object from a counts matrix with given annotations.
}
\details{
This function initializes a gemini.input object from a counts matrix. There are a few key assumptions made in the input format.
\itemize{
\item The counts matrix is regular.
\item The counts matrix structure is in accordance with the \code{samplesAreColumns} parameter.
\item The first column of \code{sample.replicate.annotation} matches with the existing dimension names of the counts matrix.
\item The first column of \code{guide.annotations} matches with the existing dimension names of the counts matrix.
\item \code{sample.column.name} must specify a column in \code{sample.replicate.annotation} (either by name or index) that describes unique samples.
\item \code{gene.column.names} must specify two columns in \code{sample.replicate.annotation} (either by name or index) that describe genes.
}
}
\examples{
data("counts", package = "gemini")
data("sample.replicate.annotation", package = "gemini")
data("guide.annotation", package = "gemini")
Input <- gemini_create_input(
    counts.matrix = counts,
    sample.replicate.annotation = sample.replicate.annotation,
    guide.annotation = guide.annotation,
    sample.column.name = "samplename",
    gene.column.names = c("U6.gene", "H1.gene")
)

}
