\name{exist.gdsn}
\alias{exist.gdsn}
\title{Return whether the path exists or not}
\description{
    Get a logical vector to show whether the path exists or not.
}

\usage{
exist.gdsn(node, path)
}
\arguments{
    \item{node}{an object of class \code{\link{gdsn.class}}, a GDS node}
    \item{path}{the path(s) specifying a GDS node with '/' as a separator}
}
\value{
    A logical vector.
}

\author{Xiuwen Zheng}
\seealso{
    \code{\link{ls.gdsn}}, \code{\link{index.gdsn}}
}

\examples{
# cteate a GDS file
f <- createfn.gds("test.gds")

# add a list to "test.gds"
node <- add.gdsn(f, name="list", val=list(x=c(1,2), y=c("T","B","C"), z=TRUE))
ls.gdsn(node)
# "x" "y" "z"

exist.gdsn(f, c("list", "list/z", "wuw/dj"))

# close the GDS file
closefn.gds(f)


# delete the temporary file
unlink("test.gds", force=TRUE)
}

\keyword{GDS}
\keyword{utilities}
