% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcat.R, R/gcat.stat.R
\name{gcat}
\alias{gcat}
\alias{gcatest}
\alias{gcat.stat}
\title{Genotype Conditional Association TEST}
\usage{
gcat(X, LF, trait, adjustment = NULL)

gcatest(X, LF, trait, adjustment = NULL)

gcat.stat(X, LF, trait, adjustment = NULL)
}
\arguments{
\item{X}{A matrix of SNP genotypes, i.e. an integer matrix of 0's,
1's, 2's and \code{NA}s.
BEDMatrix is supported.
Sparse matrices of class Matrix are not supported (yet).}

\item{LF}{matrix of logistic factors from \code{\link[lfa:lfa]{lfa::lfa()}}}

\item{trait}{vector}

\item{adjustment}{matrix of adjustment variables}
}
\value{
vector of p-values
}
\description{
Performs the GCAT association test between SNPs and trait, returning
p-values.
}
\section{Functions}{
\itemize{
\item \code{gcatest()}: Alias of gcat

\item \code{gcat.stat()}: returns the association statistics instead of the
p-value.

}}
\examples{
library(lfa)

# make example data smaller so example is fast
# goes from 1000 to 100 individuals
indexes <- sample.int( ncol(sim_geno), 100 )
sim_geno <- sim_geno[ , indexes ]
sim_trait <- sim_trait[ indexes ]

# now run LFA and GCATest
LF <- lfa(sim_geno, 3)
gcat_p <- gcat(sim_geno, LF, sim_trait)
gcat_stat <- gcat.stat(sim_geno, LF, sim_trait)
}
\references{
Song, M, Hao, W, Storey, JD (2015). Testing for genetic
associations in arbitrarily structured populations. Nat. Genet., 47, 5:550-4.
}
