% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_validators.R
\name{validate_se_assay_name}
\alias{validate_se_assay_name}
\title{Check whether or not an assay exists in a SummarizedExperiment object.}
\usage{
validate_se_assay_name(se, name)
}
\arguments{
\item{se}{A \linkS4class{SummarizedExperiment} object.}

\item{name}{String of name of the assay to validate.}
}
\value{
\code{NULL} invisibly if the assay name is valid.
Throws an error if the assay is not valid.
}
\description{
Check for the presence of an assay in a SummarizedExperiment object.
}
\examples{
mae <- get_synthetic_data("finalMAE_small") 
se <- mae[[1]]
validate_se_assay_name(se, "RawTreated")

}
\keyword{experiment}
