% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curves.R
\name{set_constant_fit_params}
\alias{set_constant_fit_params}
\title{Set fit parameters for a constant fit.}
\usage{
set_constant_fit_params(out, mean_norm_value)
}
\arguments{
\item{out}{Named list of fit parameters.}

\item{mean_norm_value}{Numeric value that be used to set all parameters
that can be calculated from the mean.}
}
\value{
Modified named list of fit parameters.
}
\description{
Replace values for flat fits: ec50 = 0, h = 0.0001 and xc50 = +/- Inf
}
\examples{
na <- list(x_0 = NA)
set_constant_fit_params(na, mean_norm_value = 0.6)

}
\keyword{fit_curves}
