% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten}
\alias{flatten}
\title{Flatten a table}
\usage{
flatten(tbl, groups, wide_cols, sep = "_")
}
\arguments{
\item{tbl}{table to flatten.}

\item{groups}{character vector of column names representing uniquifying groups in expansion.}

\item{wide_cols}{character vector of column names to flatten.}

\item{sep}{string representing separator between \code{wide_cols} columns, used in column renaming.
Defaults to \code{"_"}.}
}
\value{
table of flattened data as defined by \code{wide_cols}.
}
\description{
Flatten a stacked table into a wide format.
}
\details{
flattened columns will be named with original column names prefixed by \code{wide_cols} columns,
concatenated together and separated by \code{sep}.

A common use case for this function is
when a flattened version of the \code{"Metrics"} assay is desired.
}
\examples{
n <- 4
m <- 5
grid <- expand.grid(normalization_type = c("GR", "RV"),
  source = c("GDS", "GDR"))
repgrid <- data.table::rbindlist(rep(list(grid), m))
repgrid$wide <- seq(m * n)
repgrid$id <- rep(LETTERS[1:m], each = n)

groups <- colnames(grid)
wide_cols <- c("wide")

flatten(repgrid, groups = groups, wide_cols = wide_cols)

}
\seealso{
convert_se_assay_to_dt
}
\keyword{convert}
