% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_convert.R
\name{convert_se_to_json}
\alias{convert_se_to_json}
\title{Convert a SummarizedExperiment object to a JSON document.}
\usage{
convert_se_to_json(se)
}
\arguments{
\item{se}{SummarizedExperiment object.}
}
\value{
String representation of a JSON document.
}
\description{
Convert a SummarizedExperiment object to a JSON document.
}
\examples{
md <- list(title = "my awesome experiment",
  description = "description of experiment",
  source = list(name = "GeneData_Screener", id = "QCS-12345"))
rdata <- data.table::data.table(
 mydrug = letters, 
  mydrugname = letters, 
  mydrugmoa = letters, 
  Duration = 1)
cdata <- data.table::data.table(mycellline = letters, mycelllinename = letters,
 mycelllinetissue = letters, cellline_ref_div_time = letters)
identifiers <- list(cellline = "mycellline",
                    cellline_name = "mycelllinename",
                    cellline_tissue = "mycelllinetissue",
                    cellline_ref_div_time = "cellline_ref_div_time",
                    drug = "mydrug",
                    drug_name = "mydrugname",
                    drug_moa = "mydrugmoa",
                    duration = "Duration")
se <- SummarizedExperiment::SummarizedExperiment(rowData = rdata,
                                                 colData = cdata)
se <- set_SE_experiment_metadata(se, md)
se <- set_SE_identifiers(se, identifiers)
convert_se_to_json(se)

}
\keyword{json_convert}
