% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_convert.R
\name{convert_rowData_to_json}
\alias{convert_rowData_to_json}
\title{Convert rowData to JSON}
\usage{
convert_rowData_to_json(
  rdata,
  identifiers,
  req_cols = c("drug", "drug_name", "drug_moa", "duration")
)
}
\arguments{
\item{rdata}{data.table of \code{rowData}.}

\item{identifiers}{charvec with identifiers}

\item{req_cols}{charvec required columns}
}
\value{
JSON string capturing the \code{rdata}.
}
\description{
Convert rowData to JSON format for elasticsearch indexing.
}
\details{
Standardizes the \code{rdata} to common schema fields
and tidies formatting to be condusive to joining
with other JSON responses.
}
\examples{
rdata <- data.table::data.table(
  mydrug = letters, 
  mydrugname = letters, 
  mydrugmoa = letters, 
  Duration = 1)
identifiers <- list(drug = "mydrug", drug_name = "mydrugname", drug_moa = "mydrugmoa",
duration = "Duration")
convert_rowData_to_json(rdata, identifiers)

}
\keyword{json_convert}
