% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_curves.R
\name{cap_xc50}
\alias{cap_xc50}
\title{Cap XC50 value.}
\usage{
cap_xc50(xc50, max_conc, min_conc = NA, capping_fold = 5)
}
\arguments{
\item{xc50}{Numeric value of the IC50/GR50 to cap.}

\item{max_conc}{Numeric value of the highest concentration in a dose series used to calculate the \code{xc50}.}

\item{min_conc}{Numeric value of the lowest concentration in a dose series used to calculate the \code{xc50}.
If \code{NA} (default), using \code{max_conc/1e5} instead.}

\item{capping_fold}{Integer value of the fold number to use for capping. Defaults to \code{5}.}
}
\value{
Capped IC50/GR50 value.
}
\description{
Set IC50/GR50 value to \code{Inf} or \code{-Inf} based on upper and lower limits.
}
\details{
Note: \code{xc50} and \code{max_conc} should share the same units.
Ideally, the \code{lower_cap} should be based on the lowest tested concentration.
However, since we don't record that, it is set 5 orders of magnitude below the highest dose.
}
\examples{
cap_xc50(xc50 = 1, max_conc = 2)
cap_xc50(xc50 = 2, max_conc = 5, min_conc = 1)
cap_xc50(xc50 = 26, max_conc = 5, capping_fold = 5)

}
\keyword{fit_curves}
