% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_mae_se_assay_to_dt.R
\name{capVals}
\alias{capVals}
\title{Cap metric values}
\usage{
capVals(x)
}
\arguments{
\item{x}{\code{data.table} containing growth metrics extracted from a \code{SummarizedExperiment}}
}
\value{
A data table with capped values.
}
\description{
Convenience function to apply caps to outlying metric values.
}
\details{
The following metrics are capped at the respective values:
\itemize{
\item{\code{E max}: 0  - 1.1}
\item{\code{GR max}: -1  - 1.1}
\item{\code{RV AOC within set range}: over -0.1}
\item{\code{GR AOC within set range}: over of -0.1}
\item{\code{GR50}: 1e-4 to 30}
\item{\code{IC50}: 1e-4 to 30}
\item{\code{EC50}: 1e-4 to 30} (change 0 to NA beforehand)
}
}
\examples{
dt <- data.table::data.table(
  `E Max` = c(-0.1, 0, 0.5, 1.2),
  `GR Max` = c(-1.1, -1, 0.5, 1.2),
  `RV AOC within set range` = c(-0.2, -0.1, 0, 3),
  `GR AOC within set range` = c(-0.2, -0.1, 0, 3), 
  `GR50` = c(0, 1e-7, 10, 34),
  `IC50` = c(0, 1e-7, 10, 34),
  `EC50` = c(0, 1e-7, 10, 34),
  check.names = FALSE
)
dt
dt1 <- capVals(dt)
dt1

}
\seealso{
\code{convert_se_assay_to_dt}, \code{\link[scales]{oob}}
}
\keyword{internal}
