% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_metadata.R
\name{SE_metadata}
\alias{SE_metadata}
\alias{set_SE_fit_parameters}
\alias{set_SE_processing_metadata}
\alias{set_SE_keys}
\alias{set_SE_experiment_metadata}
\alias{set_SE_experiment_raw_data}
\alias{get_SE_fit_parameters}
\alias{get_SE_processing_metadata}
\alias{get_SE_experiment_raw_data}
\alias{get_SE_experiment_metadata}
\alias{get_SE_keys}
\alias{get_SE_identifiers}
\alias{set_SE_identifiers}
\title{Get and set metadata for parameters on a SummarizedExperiment object.}
\usage{
set_SE_fit_parameters(se, value)

set_SE_processing_metadata(se, value)

set_SE_keys(se, value)

set_SE_experiment_metadata(se, value, append = TRUE)

set_SE_experiment_raw_data(se, value)

get_SE_fit_parameters(se)

get_SE_processing_metadata(se)

get_SE_experiment_raw_data(se)

get_SE_experiment_metadata(se)

get_SE_keys(se, key_type = NULL)

get_SE_identifiers(se, id_type = NULL, simplify = TRUE)

set_SE_identifiers(se, value)
}
\arguments{
\item{se}{a \linkS4class{SummarizedExperiment} object for which to add fit parameter metadata.}

\item{value}{named list of metadata for fit parameters.}

\item{append}{Boolean indicating whether to append the new metadata value to the existing entry.}

\item{key_type}{string of a specific key type (i.e. 'nested_keys', etc.).}

\item{id_type}{string of a specific id type (i.e. 'duration', 'cellline_name', etc.).}

\item{simplify}{Boolean indicating whether output should be simplified.}
}
\value{
\code{se} with added metadata.
}
\description{
Set metadata for the fitting parameters that define the Metrics assay in SummarizedExperiment object metadata.
}
\details{
For \code{*et_SE_processing_metadata}, get/set metadata for the processing info that defines
the date_processed and packages versions in SummarizedExperiment object metadata.
For \code{*et_SE_fit_parameters}, get/set metadata for fit parameters
used to construct the Metrics assay in a SummarizedExperiment object.
}
\examples{
mae <- get_synthetic_data("finalMAE_small.qs") 
se <- mae[[1]]
get_SE_fit_parameters(se)

mae <- get_synthetic_data("finalMAE_small.qs") 
se <- mae[[1]]
meta <- get_SE_processing_metadata(se)

mae <- get_synthetic_data("finalMAE_small.qs") 
se <- mae[[1]]
get_SE_experiment_raw_data(se)

mae <- get_synthetic_data("finalMAE_small.qs") 
se <- mae[[1]]
get_SE_experiment_metadata(se)

mae <- get_synthetic_data("finalMAE_small.qs") 
se <- mae[[1]]
get_SE_identifiers(se)

}
\keyword{SE_operators}
