% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_mae_se_assay_to_dt.R
\name{convert_se_assay_to_custom_dt}
\alias{convert_se_assay_to_custom_dt}
\title{Convert a SummarizedExperiment assay to a long data.table and conduct some post processing steps}
\usage{
convert_se_assay_to_custom_dt(
  se,
  assay_name,
  output_table = NULL,
  cap_values = FALSE
)
}
\arguments{
\item{se}{A SummarizedExperiment object holding raw and/or processed dose-response data in its assays.}

\item{assay_name}{String of name of the assay to transform within the \code{se}.}

\item{output_table}{String of type name of the output data.table.}

\item{cap_values}{Logical indicating whether to apply capping (via \code{capVals}) for "Metrics" output. Default is FALSE.}
}
\value{
data.table representation of the data in \code{assay_name} with added information from \code{colData}.
}
\description{
Convert an assay within a SummarizedExperiment object to a long data.table. Then
conduct some post processing steps.
}
\details{
Current strategy is per-assay specific.
\enumerate{
\item combo assays: conversion to data.table only (with \code{wide_structure} = FALSE)
\item 'Metrics' assay can be converted to three types of outputs:
}
\itemize{
\item Metrics_initial (conversion to data.table only, with \code{wide_structure} = FALSE)
\item Metrics_raw: same as Metrics_initial followed by:
\itemize{
\item fix for 'EC50' and 'Metrics_rownames'
\item flatten
\item prettifying and dropping excess variables
}
\item Metrics (same as Metrics_raw + cap_values if \code{cap_values = TRUE})
}
\enumerate{
\item 'Normalization' and 'Averaged' assay:
}
\itemize{
\item conversion to data.table (with \code{wide_structure} = TRUE)
\item prettifying and dropping excess variables
}

NOTE: to extract information about 'Control' data, simply call the
function with the name of the assay holding data on controls.
To extract the reference data in the same format as 'Averaged' use \code{convert_se_ref_assay_to_dt}.
}
\examples{
mae <- get_synthetic_data("finalMAE_small")
se <- mae[[1]]
convert_se_assay_to_custom_dt(se, "Metrics")
convert_se_assay_to_custom_dt(se, "Metrics", output_table = "Metrics_raw")
convert_se_assay_to_custom_dt(se, "Metrics", output_table = "Metrics_initial")
convert_se_assay_to_custom_dt(se, "Averaged")
convert_se_assay_to_custom_dt(se, "Metrics", cap_values = TRUE)

}
\seealso{
convert_se_assay_to_dt
}
\keyword{convert}
