% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concatentate_SEs.R
\name{aggregate_assay}
\alias{aggregate_assay}
\title{Aggregate a \code{BumpyMatrix} assay by a given aggregation function.}
\usage{
aggregate_assay(asy, by, FUN)
}
\arguments{
\item{asy}{A \code{BumpyMatrix} object.}

\item{by}{Character vector of the nested fields to aggregate by.}

\item{FUN}{A function to use to aggregate the data.}
}
\value{
A \code{BumpyMatrix} object aggregated by \code{FUN}.
}
\description{
Aggregation can only be performed on nested variables.
}
\examples{
mae <- get_synthetic_data("finalMAE_small") 
se <- mae[[1]]
assay <- SummarizedExperiment::assay(se)
aggregate_assay(assay, FUN = mean, by = c("Barcode"))

}
\keyword{SE_operators}
