% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{annotate_dt_with_drug}
\alias{annotate_dt_with_drug}
\title{annotate_dt_with_drug}
\usage{
annotate_dt_with_drug(data, drug_annotation, fill = "unknown")
}
\arguments{
\item{data}{data.table with dose-response data}

\item{drug_annotation}{data.table with drug annotations}

\item{fill}{string indicating how unknown drugs should be filled in the DB}
}
\value{
data.table with annotated drugs
}
\description{
Annotate drug data with the provided annotation table
}
\examples{
data <- data.table::data.table(
  clid = c("CL1", "CL2", "CL3"),
  Gnumber = c("D1", "D2", "D3")
)
drug_annotation <- get_drug_annotation(data)
annotated_metadata <- annotate_dt_with_drug(data, drug_annotation)
}
\keyword{annotation}
