% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{annotate_dt_with_cell_line}
\alias{annotate_dt_with_cell_line}
\title{annotate_dt_with_cell_line}
\usage{
annotate_dt_with_cell_line(data, cell_line_annotation, fill = "unknown")
}
\arguments{
\item{data}{data.table with dose-response data}

\item{cell_line_annotation}{data.table with cell line annotations}

\item{fill}{string indicating how unknown cell lines should be filled in the DB}
}
\value{
data.table with annotated cell lines
}
\description{
Annotate cell line data with the provided annotation table
}
\examples{
data <- data.table::data.table(
  clid = c("CL1", "CL2", "CL3"),
  Gnumber = c("D1", "D2", "D3")
)
cell_line_annotation <- get_cell_line_annotation(data)
annotated_metadata <- annotate_dt_with_cell_line(data, cell_line_annotation)
}
\keyword{annotation}
