% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViewTopTargets.R
\name{ct.topTargets}
\alias{ct.topTargets}
\title{Display the log2 fold change estimates and associated standard deviations of the guides targeting the top 
candidates in a crispr screen}
\usage{
ct.topTargets(
  fit,
  summaryDF,
  annotation,
  targets = 10,
  enrich = TRUE,
  contrast.term = NULL
)
}
\arguments{
\item{fit}{An object of class \code{MArrayLM} containing, at minimum, a \code{coefficents} slot with coefficients from the comparison, 
and a \code{stdev.unscaled} slot with the corresponding standard deviation of the coefficent estimates. The \code{row.names} attribute 
should ideally match that which is found in \code{annotation}.}

\item{summaryDF}{A data.frame summarizing the results of the screen, returned by the function \code{\link{ct.generateResults}}.}

\item{annotation}{An annotation object for the experiment. gRNAs are annotated by 
row, and must minimally contain a column \code{geneSymbol}.}

\item{targets}{Either the number of top targets to display, or a list of \code{geneSymbol}s contained in the \code{geneSymbol} 
slot of the \code{annotation} object.}

\item{enrich}{Logical indicating whether to display guides that are enriched (default) or depleted within the screen. If a vector of 
\code{geneSymbol}s is specified, this controls the left-t0-right ordering of the corresponding gRNAs.}

\item{contrast.term}{If a fit object with multiple coefficients is passed in, a string indiating the coefficient of interest.}
}
\value{
An image on the default device indicating each gRNA's log2 fold change and the unscaled standard deviation of the effect estimate, 
derived from the \code{MArrayLM} object.
}
\description{
This is a function for displaying candidates from a crispr screen, using the information summarized 
in the corresponding \code{fit} and the output from \code{ct.generateResults()}. The fold change and standard deviation 
estimates for each gRNA associated with each target (extracted from the \code{coefficients} and \code{stdev.unscaled} slot 
of \code{fit}) are plotted on the y axis. Targets are selected on the basis of their gene-level enrichment or depletion 
P-values; in the case of ties, they are ranked on the basis of their corresponding Rho statistics.
}
\examples{
data('fit')
data('resultsDF')
data('ann')

ct.topTargets(fit, resultsDF, ann) 
}
\author{
Russell Bainer
}
