% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackedGuides.R
\name{ct.stackGuides}
\alias{ct.stackGuides}
\title{View a stacked representation of the most variable targets or individual guides within an experiment, 
as a percentage of the total aligned reads}
\usage{
ct.stackGuides(
  eset,
  sampleKey = NULL,
  nguides = 20,
  plotType = "gRNA",
  annotation = NULL,
  ylimit = NULL,
  subset = NULL
)
}
\arguments{
\item{eset}{An ExpressionSet  object containing, at minimum, a matrix of gRNA abundances extractable with the exprs() function, and a metadata 
object containing a column named \code{SAMPLE_LABEL} containing unique identifers for each sample. The \code{colnames} should be syntactically}

\item{sampleKey}{An optional sample key, supplied as an ordered factor linking the samples to experimental 
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the control set is assumed to be 
the first \code{level}.}

\item{nguides}{The number of guides (or targets) to display.}

\item{plotType}{A string indicating whether the individual guides should be displayed ('\code{gRNA}'), or if they should be aggregated into target-level
estimates ('\code{Target}') according to the \code{geneSymbol} column in the \code{annotation} object.}

\item{annotation}{An optional data.frame containing an annotation object to be used to aggregate the guides into targets. gRNAs are annotated by row, 
and must minimally contain a column \code{geneSymbol} indicating the target elements.}

\item{ylimit}{An optional numeric vector of length 2 specifying the y limits for the plot, useful in comparin across studies.}

\item{subset}{An optional character vector containing the sample labels to be used in the analysis; all elements must be contained in the \code{colnames} of the specified \code{eset}.}
}
\value{
A stacked barplot displaying the appropriate entities on the default device.
}
\description{
This function identifies the gRNAs or targets that change the most from sample to sample within an experiment as a percentage of 
the entire library. It then plots the abundance of the top \code{nguides} as a stacked barplot for all samples in the experiment. The purpose of this 
algorithm is to detect potential distortions in the library composition that might not be properly controlled by sample normalization, and so 
the most variable entites are defined by calculating the percent of aligned reads that they contribute to each sample, and then ranking each entity
by the range of these percentages across all samples. Consequently, gRNAs or Targets that are highly abundant in at least one condition will be 
are more likely to be identified.
}
\examples{
data('es')
data('ann')
ct.stackGuides(es, nguides = 20, plotType = 'Target', annotation = ann, ylimit = NULL, subset = NULL)
}
\author{
Russell Bainer
}
