% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileutilities.R
\name{ct.rankSimple}
\alias{ct.rankSimple}
\title{Rank Signals in a Simplified Pooled Screen Result Object}
\usage{
ct.rankSimple(df, top = c("enrich", "deplete"))
}
\arguments{
\item{df}{A results data.frame, in either raw or simplified form. Will be converted to simplified form if necessary.}

\item{top}{Determines the directionality of the ranking. `enrich` defines ranks from the most enriched to the most 
depleted target; `deplete` does the opposite}
}
\value{
A numeric vector of ranks, with length equal to the number of rows in the simplified data.frame.
}
\description{
This function takes in a supplied results data.frame, optionally transforms it into a `simplifiedResult`, 
and returns the ranks of the target-level signals.
}
\examples{
data('resultsDF')
df.simple <- ct.simpleResult(resultsDF) 
sr <- ct.rankSimple(resultsDF)
all((df.simple$best.p[sr == 1] == 0), (df.simple$direction[sr == 1] == 'enrich'))

sr <- ct.rankSimple(resultsDF, 'deplete')
all((df.simple$best.p[sr == 1] == 0), (df.simple$direction[sr == 1] == 'deplete'))
}
\author{
Russell Bainer
}
