% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{ct.parseGeneSymbol}
\alias{ct.parseGeneSymbol}
\title{Parse `geneSymbol` values to construct an alternative annotation list}
\usage{
ct.parseGeneSymbol(ann, format = c("cellecta", "underscore"))
}
\arguments{
\item{ann}{A \code{data.frame} containing reagent-level information encoded as rows. The `ID` column should correspond to the individual 
reagent identifiers, and the 'geneSymbol' column should contain target annotation strings to be parsed (both are coerced to strings). 
Does not, strictly speaking, need to be a proper annotation object, but one of those will work.}

\item{format}{Format of the geneSymbol column strings.}
}
\value{
A named `alt.annotation`-type list of character vectors encoding the target mappings for each reagent
}
\description{
This is an accessory function to `ct.expandAnnotation()` function, which enables users to expand annotation objects 
to accomodate reagent libraries where reagents are expected to impact a set of known targets. See documentation for that function for 
additional details. 

Often, libraries that contain multiply-targeting reagents are annotated using a structured format that can be decomposed by regex matching. 
This function takes in an annotation object containing an `ID` column indicating the reagent ID and a `geneSymbol` column containing the 
target mappings, and parses the target mappings according to a known annotation format. Currently supported formats are 'cellecta' 
(e.g., 'TARGET_P1P2P3' indicating multiple promoters associated with a known target), and 'underscore', where different targets are 
concatenated using the underscore separator (e.g., 'TARGET1_TARGET2_TARGET3').

Returns an `alt.annotation`-type list of character vectors encoding the target mappings for each reagent.
}
\examples{
fakeann <- data.frame('ID' = LETTERS[1:4], 'geneSymbol' = c('T1_P1', 'T1_P1P2', 'T1_P2P1', 'T1_P2'))
ct.parseGeneSymbol(fakeann, 'cellecta')
ct.parseGeneSymbol(fakeann, 'underscore')
}
\author{
Russell Bainer
}
