% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{ct.expandAnnotation}
\alias{ct.expandAnnotation}
\title{Expand an annotation object to allow annotations of reagents to multiple targets}
\usage{
ct.expandAnnotation(ann, alt.annotation)
}
\arguments{
\item{ann}{A \code{data.frame} containing an annotation object with gRNA-level information encoded as rows, typically produced by 
`ct.prepareAnnotation`. The `ID` column should correspond to the individual reagent identifiers.}

\item{alt.annotation}{A named list of character vectors, which should be named identically to a value in the `ID` column of the supplied 
annotation object. The values in the character vectors will eventually form the `geneSymbol` column of the annotation file.}
}
\value{
A new annotation data frame, expanded as described above.
}
\description{
This function takes a gCrisprTools annotation object and expands it to allow 1:many mappings of reagents. 
This mostly is used for internal processing, and users should interact with the wrapper functions that call it (e.g., `ct.generateResults`). 

Libraries targeting ambiguous biological elements (e.g., alternative promoters to a gene where the boundaries between
elements is contested) may contain reagents that are plausibly annotated to a finite set of possible targets. To accomodate this, users may 
supply an alternative reagent annotation in the form of a named list of vectors, where the names correspond to reagent `ID`s in the annotation 
object and each list element corresponds something coercible to a to a character vector of associated targets that will ultimately be assembled
into the `geneSymbol` column of the annotation object. It is assumed that the `geneID` values are assigned unambiguously to the reagents, 
and are passed through directly.
}
\examples{
data('ann')
alt.annotation <- list('Target2089_b' = c('foo', 'bar'), 'Target2089_c' = 'foo', 'Target2089_a' = 'bar')
ct.expandAnnotation(ann, alt.annotation)
}
\author{
Russell Bainer
}
