% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{rotate.Frames}
\alias{rotate.Frames}
\title{Rotates all images in a \code{Frames} object}
\usage{
rotate.Frames(frames, angle, testing = FALSE)
}
\arguments{
\item{frames}{A \code{Frames} object}

\item{angle}{The rotation angle (clockwise) specified in degrees}

\item{testing}{Logical, whether to just test the rotation or to actually perform it. Default set to \code{FALSE}}
}
\value{
A \code{Frames} object containing the rotated frames
}
\description{
Rotation is performed exploiting the rotate function of the \code{EBImage} package. Could be automated if support for coordinate/pixel interaction is included
}
\examples{
data("MesenteriumSubset")
rotate.Frames(MesenteriumSubset,angle = 40)

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
