% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setGate_Methods.R
\name{scale_gate}
\alias{scale_gate}
\alias{scale_gate.GatingHierarchy}
\alias{scale_gate,GatingHierarchy-method}
\alias{scale_gate,GatingSet-method}
\title{Simplified geometric scaling of gates associated with nodes}
\usage{
\method{scale_gate}{GatingHierarchy}(obj, y, scale = NULL, ...)
}
\arguments{
\item{obj}{A \code{GatingHierarchy} or \code{GatingSet} object}

\item{y}{A character specifying the node whose gate should be modified}

\item{scale}{Either a numeric scalar (for uniform scaling in all dimensions) or numeric vector specifying the factor by 
which each dimension of the gate should be expanded (absolute value > 1) or contracted (absolute value < 1). Negative values 
will result in a reflection in that dimension.}

\item{...}{not used}
}
\description{
Scale a gate associated with a node of a \code{GatingHierarchy} or
\code{\linkS4class{GatingSet}}. This method is a wrapper for \code{\link[flowCore]{scale_gate}} that enables 
updating of the gate associated with a node of a \code{GatingHierarchy} or \code{GatingSet}.
 
\code{scale_gate} calls \code{\link{gs_pop_set_gate}} to modify the provided \code{GatingHierarchy} or \code{GatingSet} 
directly so there is no need to re-assign its output. The arguments will be essentially identical to the 
\code{flowCore} method, except for the specification of the target gate. Rather than being called on an 
object of type \code{\link[flowCore]{filter}}, here it is called on a \code{GatingHierarchy} or \code{GatingSet} 
object with an additional character argument for specifying the node whose gate should be transformed. 
The rest of the details below are taken from the \code{flowCore} documentation.
}
\details{
This method allows uniform or non-uniform geometric scaling of filter types defined by simple geometric gates 
(\code{\linkS4class{quadGate}}, \code{\linkS4class{rectangleGate}}, \code{\linkS4class{ellipsoidGate}}, and 
\code{\linkS4class{polygonGate}}) Note that these methods are for manually altering
the geometric definition of a gate. To easily transform the definition of a gate with an accompanyging scale 
transformation applied to its underlying data, see ?ggcyto::rescale_gate.

The \code{scale} argument passed to \code{scale_gate} should be either a scalar or a vector of the same length
as the number of dimensions of the gate. If it is scalar, all dimensions will be multiplicatively scaled uniformly
by the scalar factor provided. If it is a vector, each dimension will be scaled by its corresponding entry in the vector.

The scaling behavior of \code{scale_gate} depends on the type of gate passed to it. For \code{rectangleGate} 
and \code{quadGate} objects, this amounts to simply scaling the values of the 1-dimensional boundaries. 
For \code{polygonGate} objects, the values of \code{scale} will be used to determine scale factors 
in the direction of each of the 2 dimensions of the gate (\code{scale_gate} is not yet defined
for higher-dimensional \code{polytopeGate} objects). \strong{Important: } For \code{ellipsoidGate} objects, \code{scale}
determines scale factors for the major and minor axes of the ellipse, \emph{in that order}. Scaling by a negative factor 
will result in a reflection in the corresponding dimension.
}
\examples{
\dontrun{
# Scales both dimensions by a factor of 5
scale_gate(gs, node, 5)

# Shrinks the gate in the first dimension by factor of 1/2
# and expands it in the other dimension by factor of 3
scale_gate(gs, node, c(0.5,3))
}

}
\seealso{
transform_gate \code{\link[flowCore:scale_gate]{flowCore::scale_gate}}
}
