% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setGate_Methods.R
\name{rotate_gate}
\alias{rotate_gate}
\alias{rotate_gate.GatingHierarchy}
\alias{rotate_gate,GatingHierarchy-method}
\alias{rotate_gate,GatingSet-method}
\title{Simplified geometric rotation of gates associated with nodes}
\usage{
\method{rotate_gate}{GatingHierarchy}(obj, y, deg = NULL, rot_center = NULL, ...)
}
\arguments{
\item{obj}{A \code{GatingHierarchy} or \code{GatingSet} object}

\item{y}{A character specifying the node whose gate should be modified}

\item{deg}{An angle in degrees by which the gate should be rotated in the counter-clockwise direction}

\item{rot_center}{A separate 2-dimensional center of rotation for the gate, if desired. By default, this will
be the center for \code{ellipsoidGate} objects or the centroid for \code{polygonGate} objects. The \code{rot_center} argument 
is currently only supported for \code{polygonGate} objects.}

\item{...}{not used}
}
\description{
Rotate a gate associated with a node of a \code{GatingHierarchy} or
\code{GatingSet}. This method is a wrapper for \code{\link[flowCore]{rotate_gate}} that enables 
updating of the gate associated with a node of a \code{GatingHierarchy} or \code{GatingSet}.
 
\code{rotate_gate} calls \code{\link{gs_pop_set_gate}} to modify the provided \code{GatingHierarchy} or \code{GatingSet} 
directly so there is no need to re-assign its output. The arguments will be essentially identical to the 
\code{flowCore} method, except for the specification of the target gate. Rather than being called on an 
object of type \code{flowCore:filter}, here it is called on a \code{GatingHierarchy} or \code{GatingSet} 
object with an additional character argument for specifying the node whose gate should be transformed. 
The rest of the details below are taken from the \code{flowCore} documentation.
}
\details{
This method allows for geometric rotation of filter types defined by simple geometric gates 
(\code{\linkS4class{ellipsoidGate}}, and \code{\linkS4class{polygonGate}}). The method is not defined 
for \code{rectangleGate} or \code{quadGate} objects, due to their definition as having 1-dimensional boundaries.

The angle provided in the \code{deg} argument should be in degrees rather than radians. By default, the rotation
will be performed around the center of an \code{ellipsoidGate} or the centroid of the area encompassed by
a \code{polygonGate}. The \code{rot_center} argument allows for specification of a different center of rotation
for \code{polygonGate} objects (it is not yet implemented for \code{ellipsoidGate} objects) but
it is usually simpler to perform a rotation and a translation individually than to manually specify 
the composition as a rotation around a shifted center.
}
\examples{
\dontrun{
#' # Rotates the original gate 15 degrees counter-clockwise
rotate_gate(gs, node, deg = 15)
# Rotates the original gate 270 degrees counter-clockwise
rotate_gate(gs, node, 270)
}

}
\seealso{
transform_gate \code{\link[flowCore:rotate_gate]{flowCore::rotate_gate}}
}
