% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_fcs.R
\name{load_cytoset_from_fcs}
\alias{load_cytoset_from_fcs}
\title{Read one or several FCS files in to a cytoset}
\usage{
load_cytoset_from_fcs(
  files = NULL,
  path = ".",
  pattern = NULL,
  phenoData = NULL,
  descriptions,
  name.keyword,
  transformation = "linearize",
  which.lines = NULL,
  decades = 0,
  is_h5 = NULL,
  h5_dir = NULL,
  backend = get_default_backend(),
  backend_dir = tempdir(),
  min.limit = NULL,
  truncate_max_range = TRUE,
  dataset = NULL,
  emptyValue = TRUE,
  num_threads = 1,
  ignore.text.offset = FALSE,
  sep = "\\t",
  as.is = TRUE,
  name,
  file_col_name = NULL,
  ...
)
}
\arguments{
\item{files}{Optional character vector with filenames.}

\item{path}{Directory where to look for the files.}

\item{pattern}{This argument is passed on to
\code{\link[base:list.files]{dir}}, see details.}

\item{phenoData}{An object of class \code{AnnotatedDataFrame},
\code{character} or a list of values to be extracted from the
\code{\link{cytoframe}} object, see details.}

\item{descriptions}{Character vector to annotate the object of class
\code{\link{cytoset}}.}

\item{name.keyword}{An optional character vector that specifies which FCS
keyword to use as the sample names. If this is not set, the GUID of the FCS
file is used for sampleNames, and if that is not present (or not unique),
then the file names are used.}

\item{transformation}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{which.lines}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{decades}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{is_h5}{logical indicating whether the data should be stored in h5 format}

\item{h5_dir}{String specifying a name for the h5 directory
for the h5 files if \code{is_h5} is TRUE}

\item{min.limit}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{truncate_max_range}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{dataset}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{emptyValue}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{num_threads}{Integer allowing for parallelization of the parsing
operation by specifiying a number of threads}

\item{ignore.text.offset}{see \code{\link{load_cytoframe_from_fcs}} for details.}

\item{sep}{Separator character that gets passed on to
\code{\link[Biobase]{read.AnnotatedDataFrame}}.}

\item{as.is}{logical that gets passed on to
\code{\link[Biobase]{read.AnnotatedDataFrame}}. This controls the automatic
coercion of characters to factors in the \code{phenoData}.}

\item{name}{An optional character scalar used as name of the object.}

\item{file_col_name}{optionally specify the column name that stores the fcs filename when phenoData is supplied
\code{\link[Biobase]{read.AnnotatedDataFrame}}, see details.}

\item{\dots}{Further arguments that get passed on to}
}
\value{
An object of class \code{\link{cytoset}}.
}
\description{
Similar to \code{\link[flowCore]{read.flowSet}}, this takes a list of FCS filenames
and returns a \code{cytoset}.
}
\details{
There are four different ways to specify the file from which data is to be
imported:

First, if the argument \code{phenoData} is present and is of class
\code{\link[Biobase:class.AnnotatedDataFrame]{AnnotatedDataFrame}}, then the
file names are obtained from its sample names (i.e. row names of the
underlying data.frame).  Also column \code{name} will be generated based on
sample names if it is not there. This column is mainly used by visualization
methods in flowViz.  Alternatively, the argument \code{phenoData} can be of
class \code{character}, in which case this function tries to read a
\code{AnnotatedDataFrame} object from the file with that name by calling
\code{\link[Biobase]{read.AnnotatedDataFrame}(file.path(path,phenoData),\dots{})}.

In some cases the file names are not a reasonable selection criterion and
the user might want to import files based on some keywords within the file.
One or several keyword value pairs can be given as the phenoData argument in
form of a named list.

Third, if the argument \code{phenoData} is not present and the argument
\code{files} is not \code{NULL}, then \code{files} is expected to be a
character vector with the file names.

Fourth, if neither the argument \code{phenoData} is present nor \code{files}
is not \code{NULL}, then the file names are obtained by calling
\code{dir(path, pattern)}.
}
\seealso{
Other cytoframe/cytoset IO functions: 
\code{\link{cf_get_uri}()},
\code{\link{cf_write_disk}()},
\code{\link{cf_write_h5}()},
\code{\link{cs_get_uri}()},
\code{\link{load_cytoframe_from_fcs}()},
\code{\link{load_cytoframe}()}
}
\concept{cytoframe/cytoset IO functions}
