% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_GatingSet.R
\name{gs_remove_redundant_nodes}
\alias{gs_remove_redundant_nodes}
\alias{dropRedundantNodes}
\title{Remove the terminal leaf nodes that make the gating trees to be different from one another.}
\usage{
gs_remove_redundant_nodes(x, toRemove)
}
\arguments{
\item{x}{\code{GatingSet} or \code{list} of groups(each group is a list of 'GatingSet`). When it is a list, it is usually the outcome from \link{gs_split_by_tree}.}

\item{toRemove}{\code{list} of the node sets to be removed. its length must equals to the length of 'x'. When \code{x} is a list, \code{toRemove} is usually the outcome from \link{gs_check_redundant_nodes}.}
}
\description{
It is usually called after \link{gs_split_by_tree} and \link{gs_check_redundant_nodes}. The operation is done in place through external pointers which means
all the orginal GatingSets are modified.
}
\examples{
\dontrun{
gslist <- list(gs1, gs2, gs3, gs4, gs5)
gs_groups <- gs_split_by_tree(gslist)
toRm <- gs_check_redundant_nodes(gs_groups)
gs_remove_redundant_nodes(gs_groups, toRm)

#Now they can be merged into a single GatingSetList.
#Note that the original gs objects are all modified in place.
GatingSetList(gslist)
}
}
