% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Methods.R
\name{gs_pop_add}
\alias{gs_pop_add}
\alias{add}
\alias{add,default-method}
\alias{Rm}
\alias{gs_pop_remove}
\title{Create a GatingSet and add/remove the flowCore gate(or population) to/from a GatingHierarchy/GatingSet.}
\usage{
gs_pop_add(gs, gate, validityCheck = TRUE, ...)

gs_pop_remove(gs, node, ...)
}
\arguments{
\item{gs}{A \code{GatingSet}}

\item{gate}{A \code{flowCore::filter} or a list of \code{flowCore::filter}s or \code{logical} vectors to be added to the \code{GatingSet}.
when logical vectors, they represent the indices of events to be included in the populations. It can be global that represents
the index to the original full events or local index that is relative to the parent population cell events. See examples for more
details.}

\item{validityCheck}{\code{logical} whether to check the consistency of tree structure across samples. default is TRUE. Can be turned off when speed is prefered to the robustness.}

\item{...}{some other arguments to specify how the gates are added to the gating tree.
\itemize{
        \item names  a \code{character} vector of length four,which specifies the population names resulted by adding a \code{quadGate}.The order of the names is clock-wise starting from the top left quadrant population.
        \item parent a \code{character} scalar to specify the parent node name where the new gate to be added to, by default it is NULL,which indicates the root node
        \item name a \code{character} scalar to specify the node name of population that is generated by the gate to be added.
        \item recompute a \code{logical} flag

      \item negated: a \code{logical} scalar to specify whether the gate is negated,which means the the population outside of the gate will be kept as the result population.
      It is FALSE by default. 
 }}

\item{node}{A \code{character} identifies the population node in a \code{GatingHierrarchy} or \code{GatingSet} to remove}
}
\value{
\code{GatingSet} method returns a \code{GatingSet} object with just root node.  
  \code{add} method returns a population node ID (or four population node IDs when adding a \code{quadGate}) that uniquely identify the population node within a  \code{GatingHierarchy}.
}
\description{
\code{GatingSet} method creates a gatingset from a flowSet with the ungated data as the root node.
\code{add} method add the flowCore gate to a GatingHierarchy/GatingSet.
\code{gs_pop_set_gate} method update the gate of one population node in GatingHierarchy/GatingSet.
\code{Rm} method Remove the population node from a GatingHierarchy/GatingSet. 
They are equivalent to the \code{workFlow},\code{add} and \code{Rm} methods in \code{flowCore} package. 
\code{recompute} method does the actual gating after the gate is added,i.e. calculating the event indices according to the gate definition.
}
\examples{
\dontrun{
    library(flowCore)
    data(GvHD)
#select raw flow data
    fs<-GvHD[1:3]
    
#transform the raw data
    tf <- transformList(colnames(fs[[1]])[3:6], asinh, transformationId="asinh")
    fs_trans<-transform(fs,tf)
    
#add transformed data to a gatingset
    gs <- GatingSet(fs_trans)
    gs
    gs_get_pop_paths(gs[[1]]) #only contains root node
    
#add one gate
    rg <- rectangleGate("FSC-H"=c(200,400), "SSC-H"=c(250, 400),
        filterId="rectangle")
    
    nodeID<-gs_pop_add(gs, rg)#it is added to root node by default if parent is not specified
    nodeID
    gs_get_pop_paths(gs[[1]]) #the second population is named after filterId of the gate 
    
#add a quadGate
    qg <- quadGate("FL1-H"=2, "FL2-H"=4)
    nodeIDs<-gs_pop_add(gs,qg,parent="rectangle")
    nodeIDs #quadGate produces four population nodes
    gs_get_pop_paths(gs[[1]]) #population names are named after dimensions of gate if not specified
    
#add a boolean Gate
    bg<-booleanFilter(`CD15 FITC-CD45 PE+|CD15 FITC+CD45 PE-`)
    bg
    nodeID2<-gs_pop_add(gs,bg,parent="rectangle")
    nodeID2
    gs_get_pop_paths(gs[[1]])
#do the actual gating
    recompute(gs)
    
#plot one gate for one sample
    autoplot(gs[[1]],"rectangle")
    autoplot(gs[[1]],nodeIDs) #may be smoothed automatically if there are not enough events after gating
    
#plot gates across samples 
    autoplot(gs,nodeID)
#plot all gates for one sample
    autoplot(gs[[1]])#boolean gate is skipped by default 
    autoplot(gs[[1]],bool=TRUE)
    
#plot the gating hierarchy
    plot(gs[[1]])
#remove one node causing the removal of all the descendants 
    gs_pop_remove('rectangle', gs = gs)
    gs_get_pop_paths(gs[[1]])
    
    #add logical vectors as gate
    lg <- sapply(sampleNames(gs), function(sn){
                                   gh <- gs[[sn]]
                                   dat <- exprs(gh_pop_get_data(gh, "cd3+"))#get events data matrix for this sample at cd3+ node
                                   vec <- dat[, "FSC-A"] > 1e4 & data[, "SSC-A"] > 1e5
                                   vec
                                   })
   gs_pop_add(gs, lg, name = "new_bool", parent = "cd3+")
 }
}
\seealso{
\code{\link{GatingSet-class}}
}
