% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateIndices.R
\name{gh_pop_set_indices}
\alias{gh_pop_set_indices}
\alias{updateIndices}
\alias{updateIndices,GatingHierarchy,character,logical-method}
\title{directly update event indices without changing gates}
\usage{
gh_pop_set_indices(obj, y, z)
}
\arguments{
\item{obj}{\code{GatingHierarchy} object}

\item{y}{\code{character} node name or path}

\item{z}{\code{logical} vector as local event indices relative to node \code{y}}
}
\description{
It is useful when we want to alter the popluation at events level yet
without removing or adding the existing gates.
}
\examples{
library(flowWorkspace)
dataDir <- system.file("extdata",package="flowWorkspaceData")
suppressMessages(gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE)))
gh <- gs[[1]]
#get pop counts
pop.stats <- gh_pop_get_stats(gh, nodes = c("CD3+", "CD4", "CD8"))
pop.stats

# subsample 30\% cell events at CD3+ node
total <- gh_pop_get_count(gh, "root")
gInd <- seq_len(total) #create integer index for cd3
gInd <- sample.int(total, size = total * 0.3) #randomly select 30\%
#convert it to logicle index
gInd.logical <- rep(FALSE, total)
gInd.logical[gInd] <- TRUE
#replace the original index stored at GatingHierarchy
gh_pop_set_indices(gh, "CD3+", gInd.logical)
#check the updated pop counts
gh_pop_get_stats(gs[[1]], nodes = c("CD3+", "CD4", "CD8")) #note that CD4, CD8 are not updated
#update all the descendants of CD3+
nodes <- gh_pop_get_descendants(gh, "CD3+")
for (node in nodes) suppressMessages(recompute(gh, node))
gh_pop_get_stats(gs[[1]], nodes = c("CD3+", "CD4", "CD8")) #now all are update to date
}
