% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoframe.R, R/cytoset.R
\docType{methods}
\name{convert}
\alias{convert}
\alias{cytoframe_to_flowFrame}
\alias{flowFrame_to_cytoframe}
\alias{cytoset_to_flowSet}
\alias{flowSet_to_cytoset}
\alias{cytoset_to_list}
\alias{flowSet_to_list}
\title{Methods for conversion between flowCore and flowWorkspace data classes}
\usage{
cytoframe_to_flowFrame(cf)

flowFrame_to_cytoframe(fr, ...)

cytoset_to_flowSet(cs)

flowSet_to_cytoset(
  fs,
  path = tempfile(),
  backend = get_default_backend(),
  tmp = tempfile(),
  ...
)

cytoset_to_list(cs)
}
\arguments{
\item{cf}{cytoframe object}

\item{fr}{flowframe}

\item{...}{additional arguments passed to
\code{\link{load_cytoframe_from_fcs}} or
\code{\link{load_cytoset_from_fcs}}.}

\item{cs}{cytoset}

\item{fs}{flowSet or ncdfFlowSet}

\item{path}{the h5 path for cytoset}

\item{tmp}{the temp folder when the temporary files are written to during
conversion by default, it is system temp path. And it can be changed to the
customized location when there is not enough space at system path.}
}
\description{
These methods perform conversions between flowWorkspace classes (\link{cytoframe}/\link{cytoset}) and 
flowCore classes (\link{flowFrame}/\link{flowSet}) as well as between single-sample and aggregated classes
(e.g. between \code{cytoset} and a list of \code{cytoframe}s)
}
\details{
The first set of methods consist of a pair of methods to coerce a \code{cytoframe}
to or from a \code{flowFrame} and another pair to coerce a \code{cytoset}
to or from a \code{flowSet}.

The conversion between the two sets of data container classes mostly entails
a conversion of the back-end representation of the data. \code{cytoframe}
and \code{cytoset} objects contain \code{flowFrame} and \code{flowSet} objects
respectively, so coercion of a \code{cytoframe} to \code{flowFrame} entails
moving the data from the 'C'-level data structure to the corresponding
\code{exprs}, \code{description}, and \code{parameters} slots. Coercion of
a \code{flowFrame} to a \code{cytoframe} entails creation of the 'C'-level
data structure from the \code{flowFrame} slots. The names of each of the
methods are pretty self-explanatory.

The second set of methods perform disaggregation of data objects that represent
multiple samples in to lists of data objects that represent a single sample. The opposite
direction is handled by the constructors for the aggregate data classes.
}
\section{Methods}{


\describe{
\item{cytoframe_to_flowFrame(object = "cytoframe")}{Returns a \code{flowFrame} object
coerced from a \code{cytoframe} object.}

\item{flowFrame_to_cytoframe(object = "flowFrame")}{Returns a \code{cytoframe} object
coerced from a \code{flowFrame} object.}

\item{cytoset_to_flowSet(object = "cytoset")}{Returns a \code{flowSet} object
coerced from a \code{cytoset} object.}

\item{flowSet_to_cytoset(object = "flowSet")}{Returns a \code{cytoset} object
coerced from a \code{flowSet} object.}

\item{flowSet_to_list(object = "flowSet")}{Returns a list of \code{cytoframe} objects
with names provided by the sampleNames of the original \code{cytoset}}

\item{flowSet(object = "list)}{Constructs a \code{cytoset} object from a list of \code{cytoframe}
objects. See documentation for \link{cytoset}}

\item{cytoset_to_list(object = "cytoset")}{Returns a list of \code{cytoframe} objects
with names provided by the sampleNames of the original \code{cytoset}}

\item{cytoset(object = "list)}{Constructs a \code{cytoset} object from a list of \code{cytoframe}
objects. See documentation for \link{flowSet}}
}
}

\examples{
library(flowCore)
data("GvHD")
fs <- GvHD[1]
cs <- flowSet_to_cytoset(fs)
cf <- cs[[1, returnType="cytoframe"]]
ff <- cytoframe_to_flowFrame(cf)

}
\seealso{
\link{merge_list_to_gs}
}
\keyword{methods}
