% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_GatingSet.R
\name{standardize-GatingSet}
\alias{standardize-GatingSet}
\alias{merge-GatingSet}
\title{The tools to standardize the tree structures and channel names.}
\description{
gs_split_by_tree(x)

gs_split_by_channels(x)

gs_check_redundant_nodes(x)

gs_remove_redundant_nodes(x, toRemove)

gs_remove_redundant_channels(gs)

gs_update_channels(gs, map, all = TRUE)

gh_pop_move(gh, node, to)

gs_pop_set_visibility(x, y, FALSE)
}
\details{
In order to merge multiple GatingSets into single \link{GatingSetList}, the gating trees and channel names must be
consistent. These functions help removing the discrepancies and standardize the GatingSets so that they are mergable.

\link{gs_split_by_tree} splits the GatingSets into groups based on the gating tree structures.

\link{gs_split_by_channels} split GatingSets into groups based on their flow channels.

\link{gs_check_redundant_nodes} returns the terminal(or leaf) nodes that makes the gating trees to be different among GatingSets and thus can be considered to remove as redundant nodes.

\link{gs_remove_redundant_nodes} removes the terminal(or leaf) nodes that are detected as redundant by \code{gs_check_redundant_nodes}.

\link{gs_remove_redundant_channels} remove the redundant channels that are not used by any gate defined in the GatingSet.

\link{gs_update_channels} modifies the channel names in place. (Usually used to standardize the channels among GatingSets due to the letter case discrepancies or typo).

\link{gh_pop_move} inserts a dummy gate to the GatingSet. Is is useful trick to deal with the extra non-leaf node in some GatingSets that can not be simply removed by \code{gs_remove_redundant_nodes}

\link{gs_pop_set_visibility} hide a node/gate in a GatingSet. It is useful to deal with the non-leaf node that causes the tree structure discrepancy.
}
