% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoframe.R, R/cytoset.R,
%   R/GatingHierarchy_Methods.R, R/GatingSet_Methods.R
\name{keyword-mutators}
\alias{keyword-mutators}
\alias{cf_keyword_insert}
\alias{cf_keyword_rename}
\alias{cf_keyword_delete}
\alias{cf_keyword_set}
\alias{cs_keyword_insert}
\alias{cs_keyword_rename}
\alias{cs_keyword_delete}
\alias{cs_keyword_set}
\alias{gh_keyword_insert}
\alias{gh_keyword_rename}
\alias{gh_keyword_delete}
\alias{gh_keyword_set}
\alias{gs_keyword_insert}
\alias{gs_keyword_rename}
\alias{gs_keyword_delete}
\alias{gs_keyword_set}
\title{Methods to alter keywords in \code{cytoframe}, \code{cytoset}, \code{GatingHierarchy}, or \code{GatingSet} objects}
\usage{
cf_keyword_insert(cf, keys, values)

cf_keyword_delete(cf, keys)

cf_keyword_rename(cf, old_keys, new_keys)

cf_keyword_set(cf, keys, values)

cs_keyword_insert(cs, keys, values)

cs_keyword_delete(cs, keys)

cs_keyword_rename(cs, old_keys, new_keys)

cs_keyword_set(cs, keys, values)

gh_keyword_insert(gh, keys, values)

gh_keyword_delete(gh, keys)

gh_keyword_rename(gh, old_keys, new_keys)

gh_keyword_set(gh, keys, values)

gs_keyword_insert(gs, keys, values)

gs_keyword_delete(gs, keys)

gs_keyword_rename(gs, old_keys, new_keys)

gs_keyword_set(gs, keys, values)
}
\arguments{
\item{cf}{a \code{\link{cytoframe}}}

\item{keys}{the keyword names to insert/delete/replace -- single value or vector}

\item{values}{the values to associate with the supplied keywords -- single value or vector of sample length as keys}

\item{old_keys}{the old keyword name (for renaming)}

\item{new_keys}{the new keyword name (for renaming)}

\item{cs}{a \code{\link{cytoset}}}

\item{gh}{a \code{\link{GatingHierarchy}}}

\item{gs}{a \code{\link{GatingSet}}}
}
\description{
These methods allow for direct insertion, deletion, or renaming
of keywords in \code{\link{cytoframe}}, \code{\link{cytoset}}, \code{\link{GatingHierarchy}}, 
or \code{\link{GatingSet}} objects.
}
\details{
Each of the methods taking two character vectors (keys/values or old_keys/new_keys)
will also accept a single named vector for flexibility in usage. 

For the functions that take a vector of keys and a vector of values (the \code{keyword_insert} and \code{keyword_set} functions), 
the names of this vector should be the keys to which the values of the vector will be assigned. 

For the \code{keyword_rename} functions, the names of this vector should be the existing keyword names (\code{old_keys})
while the values should be the replacement keyword names (\code{new_keys}).

See examples for details
}
\examples{
library(flowCore)
data(GvHD)
cs <- flowSet_to_cytoset(GvHD[1:2])

keys <- c("CYTNUM", "CREATOR")

# Values before changes
keyword(cs, keys)

# Set two keyword values using separate key and values vectors
values <- c("E3598", "CELLQuest  3.4")
cs_keyword_set(cs, keys, values)

# Values after changes
keyword(cs, keys)

# Change the values again using a single named vector
values <- c("E3599", "CELLQuest  3.5")
names(values) <- keys
cs_keyword_set(cs, values)

# Values after changes
keyword(cs, keys)

}
