% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStats.R
\name{gs_pop_get_stats}
\alias{gs_pop_get_stats}
\alias{gh_pop_get_stats}
\alias{getStats}
\alias{getStats,GatingSet-method}
\alias{getStats,GatingHierarchy-method}
\alias{getStats,GatingSetList-method}
\title{Extract stats from populations(or nodes)}
\usage{
gs_pop_get_stats(x, ...)

gh_pop_get_stats(
  x,
  nodes = NULL,
  type = "count",
  xml = FALSE,
  inverse.transform = FALSE,
  stats.fun.arg = list(),
  ...
)
}
\arguments{
\item{x}{a GatingSet or GatingHierarchy}

\item{...}{arguments passed to \link{gs_get_pop_paths} method.}

\item{nodes}{the character vector specifies the populations of interest. default is all available nodes}

\item{type}{the character vector specifies the type of pop stats or
a function used to compute population stats.
when character, it is expected to be either "count" or "percent". Default is "count" (total number of events in the populations).
when a function,  it takes a flowFrame object through 'fr' argument and return the stats as a named vector.}

\item{xml}{whether to extract xml stats or openCyto stats}

\item{inverse.transform}{logical flag . Whether inverse transform the data before computing the stats.}

\item{stats.fun.arg}{a list of arguments passed to `type` when 'type' is a function.}
}
\value{
a data.table that contains stats values (if MFI, for each marker per column)
 along with 'pop' column and 'sample' column (when used on a 'GatingSet')
}
\description{
Extract stats from populations(or nodes)
}
\examples{
\dontrun{
dataDir <- system.file("extdata",package="flowWorkspaceData")
suppressMessages(gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE)))

# get stats all nodes
dt <- gs_pop_get_stats(gs) #default is "count"

nodes <- c("CD4", "CD8")
gs_pop_get_stats(gs, nodes, "percent")

# pass a build-in function
gs_pop_get_stats(gs, nodes, type = pop.MFI)

# compute the stats based on the raw data scale
gs_pop_get_stats(gs, nodes, type = pop.MFI, inverse.transform = TRUE)

# supply user-defined stats fun
pop.quantiles <- function(fr){
   chnls <- colnames(fr)
   res <- matrixStats::colQuantiles(exprs(fr), probs = 0.75)
   names(res) <- chnls
   res
   }
gs_pop_get_stats(gs, nodes, type = pop.quantiles)
}
}
