% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet_Methods.R
\name{gh_apply_to_cs}
\alias{gh_apply_to_cs}
\alias{GatingSet,GatingHierarchy,character-method}
\title{Construct a \code{GatingSet} using a template}
\usage{
gh_apply_to_cs(x, cs, swap_cols = FALSE, compensation_source = "sample", ...)
}
\arguments{
\item{x}{GatingHierarchy}

\item{cs}{a cytoset}

\item{swap_cols}{for internal usage}

\item{compensation_source}{One of the following options:
\itemize{
  \item "sample" -- each cytoframe will be compensated with the spillover matrix included in its own FCS
  \item "template" -- all cytoframes will be compensatied with the spillover matrix of the template GatingHierarchy
  \item "none" -- no compensation will be applied
}}

\item{...}{not currently used}
}
\value{
a \code{GatingSet}
}
\description{
This uses a \code{\link{GatingHierarchy}} as a template to apply to other loaded samples in the form of a \code{\link{cytoset}},
resulting in a \code{\link{GatingSet}}. The transformations and gates from the template are applied to all samples. The compensation
applied to each of the samples can be controlled via the \code{compensation_source} argument.
}
