% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_trans.R
\name{flowjo_biexp_trans}
\alias{flowjo_biexp_trans}
\alias{flowJo_biexp_trans}
\title{flowJo biexponential transformation.}
\usage{
flowjo_biexp_trans(..., n = 6, equal.space = FALSE)

flowJo_biexp_trans(...)
}
\arguments{
\item{...}{parameters passed to \code{\link[flowWorkspace]{flowJoTrans}}}

\item{n}{desired number of breaks (the actual number will be different depending on the data range)}

\item{equal.space}{whether breaks at equal-spaced intervals}
}
\value{
biexponential transformation object
}
\description{
Used for constructing biexponential transformation object.
}
\examples{
library(flowCore)
data(GvHD)
fr <- GvHD[[1]]
data.raw <- exprs(fr)[, "FL1-H"]
trans.obj <- flowjo_biexp_trans(equal.space = TRUE)
brks.func <- trans.obj[["breaks"]]
brks <- brks.func(data.raw)
brks # biexp space displayed at raw data scale

#transform it to verify it is equal-spaced at transformed scale
trans.func <- trans.obj[["transform"]]

print(trans.func(brks))
}
