% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_trans.R
\name{asinh_Gml2}
\alias{asinh_Gml2}
\title{inverse hyperbolic sine transform function generator (GatingML 2.0 version)}
\usage{
asinh_Gml2(T = 262144, M = 4.5, A = 0, inverse = FALSE)
}
\arguments{
\item{T}{numeric the maximum value of input data}

\item{M}{numeric the full width of the transformed display in asymptotic decades}

\item{A}{numeric Additional negative range to be included in the display in asymptotic decades}

\item{inverse}{whether to return the inverse function}
}
\value{
fasinh/fsinh transform function
}
\description{
hyperbolic sine/inverse hyperbolic sine transform function constructor.
It is simply a special form of \code{flowjo_fasinh} with \code{length} set to 1
and different default values for parameters \code{t,m,a}.
}
\examples{
trans <- asinh_Gml2()
data.raw <- c(1,1e2,1e3)
data.trans <- trans(data.raw)
data.trans

inverse.trans <- asinh_Gml2(inverse = TRUE)
inverse.trans(data.trans)

}
