% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GatingHierarchy-class}
\alias{GatingHierarchy-class}
\alias{show,GatingHierarchy-method}
\alias{GatingHierarchy}
\title{Class GatingHierarchy}
\description{
GatingHierarchy is a class for representing the gating hierarchy,which can be either imported from a flowJo workspace or constructed in R.
}
\details{
There is a one-to-one correspondence between GatingHierarchy objects and FCS files in the flowJo workspace. 
Each sample (FCS file) is associated with it's own GatingHierarchy. It is also more space efficient by storing gating results as logical/bit vector instead of copying the raw data.

Given a GatingHierarchy, one can extract the data associated with any subpopulation, extract gates, plot gates, and extract population proportions. This facilitates the comparison of manual gating methods with automated gating algorithms.
}
\examples{
\dontrun{
 require(flowWorkspaceData)
 d<-system.file("extdata",package="flowWorkspaceData")
 wsfile<-list.files(d,pattern="A2004Analysis.xml",full=TRUE)
 library(CytoML)
 ws <- open_flowjo_xml(wsfile);
 G<-try(flowjo_to_gatingset(ws,path=d,name=1));
 gh <- G[[1]]
 gh_pop_compare_stats(gh);
 gh_plot_pop_count_cv(gh)
 nodes <- gs_get_pop_paths(gh)
 thisNode <- nodes[4]
 require(ggcyto)
 autoplot(gh,thisNode);
 gh_pop_get_gate(gh,thisNode);
 gh_pop_get_data(gh,thisNode)
}
}
\seealso{
\code{\linkS4class{GatingSet}}
}
