% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfplot.R
\docType{methods}
\name{prepanel.ecdfplot.flowset}
\alias{prepanel.ecdfplot.flowset}
\alias{panel.ecdfplot.flowset}
\alias{ecdfplot}
\alias{ecdfplot,formula,flowSet-method}
\title{Method implementing Lattice ECDF plots for flow data}
\usage{
prepanel.ecdfplot.flowset(x, frames, channel, f.value, ...)

panel.ecdfplot.flowset(x, frames, channel, f.value, ref = TRUE,
  groups = NULL, subscripts, col = superpose.symbol$col,
  col.points = col, pch = superpose.symbol$pch,
  cex = superpose.symbol$cex, alpha = superpose.symbol$alpha,
  col.line = col, lty = superpose.line$lty, lwd = superpose.line$lwd,
  ...)

\S4method{ecdfplot}{formula,flowSet}(x, data, xlab, f.value = function(n)
  ppoints(ceiling(sqrt(n))), prepanel = prepanel.ecdfplot.flowset,
  panel = panel.ecdfplot.flowset, type = "l", as.table = TRUE, ...)
}
\arguments{
\item{x}{a formula describing the structure of the plot and the variables to
be used in the display.  For the prepanel and panel functions, a vector of
names for the flow frames to be used in the panel.}

\item{frames}{environment containing frame-specific data}

\item{channel}{expression involving names of columns in the data}

\item{f.value}{determines the number of points used in the plot
\code{\link[latticeExtra:ecdfplot]{ecdfplot}} for details.}

\item{\dots}{more arguments, usually passed on to the underlying lattice
methods and the panel function.}

\item{ref}{logical; whether to add reference lines at 0 and 1}

\item{groups, subscripts}{grouping variable, if specified, and subscripts
indexing which frames are being used in the panel.  See
\code{\link[lattice:xyplot]{xyplot}} for details.}

\item{col, col.points, pch, cex, alpha, col.line, lty, lwd}{vector of graphical
parameters that are replicated for each group}

\item{data}{a \code{flowSet} object that serves as a source of data}

\item{xlab}{Labels for data axes, with suitable defaults taken from the
formula}

\item{panel, prepanel}{the panel and prepanel functions.}

\item{type}{type of rendering; by default lines are drawn}

\item{as.table}{logical; whether to draw panels from top left}
}
\description{
This function creates Trellis displays of Empirical Cumulative Distribution
Functions from flow cytometry data using a formula interface.
}
\section{Methods}{
 \describe{

\item{ecdfplot}{\code{signature(x = "formula", data = "flowSet")}: plote
empirical CDF for a given channel, with one or more samples per panel } }
}

\examples{

library(flowCore)
data(GvHD)

ecdfplot(~ `FSC-H` | Patient, GvHD, f.value = ppoints(100))

ecdfplot(~ asinh(`FSC-H`) | Patient, GvHD,
         strip = strip.custom(strip.names = TRUE),
         ref = FALSE)

ecdfplot(~ asinh(`FSC-H`) | Patient, GvHD, groups = Visit,
         strip = strip.custom(strip.names = TRUE),
         ref = FALSE, auto.key = list(columns = 4))


}
\seealso{
Not all standard lattice arguments will have the intended effect,
but many should.  For a fuller description of possible arguments and their
effects, consult documentation on lattice.
}
\keyword{dplot}
\keyword{methods}
