% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcTrans.R
\name{arcTrans}
\alias{arcTrans}
\title{Efficient inverse hyperbolic cosine transformation}
\usage{
arcTrans(flowObj, transNames, transCoFacs = "default", unTrans = FALSE)
}
\arguments{
\item{flowObj}{The fcs object to be transformed. Both flowFrames and flowSets
are accepted.}

\item{transNames}{The variables that should be normalized.}

\item{transCoFacs}{This value or vector of values define the values for the
transformation during the normalization. In the "default" case, the function
defines the object as a CyTOF object if >5 percent of the values are 0, and
applies the transformation value 5. Otherwise, the value 400 is applied.}

\item{unTrans}{If the reverse action should be taken, i.e. if an already
transformed dataset should be un-transformed. NB! It is of great importance
that the same transformation factors are used!}
}
\value{
A flow object containing the transformed data, and with all metadata
left untouched.
}
\description{
This is a simple wrapper function for the base asinh function, that is useful
for flowFrames and flowSets. It also allows for reversing the transformation
with the argument "unTrans".
}
\examples{
# Import some data and the spectral matrix. The latter can be generated using
# specMatCalc
data(fullPanel)
data(specMat)

fullPanelUnmixed <- specUnmix(fullPanel, specMat)

# Identify the columns that should be transformed
colnames(fullPanelUnmixed)
# The time and scatter parameters should not, but apart from that, all should
# be included.
transNames <- colnames(fullPanelUnmixed)[seq(6,18)]

# ow, transform this file, with the default transformation factor of 400.
# NB! It is alway advisable to visually (or computationally) check the data
# for the most optimal transformation factors. These often vary from marker
# to marker.

fullPanelTrans <- arcTrans(fullPanelUnmixed, transNames)

}
