% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_flowGraphSubset_constructor.R
\name{get_paren}
\alias{get_paren}
\title{Gets parent populations of given cell populations}
\usage{
get_paren(childs, pparen, pc__i, ac_, meta_cell_)
}
\arguments{
\item{childs}{Character vector of cell population phenotypes.}

\item{pparen}{Edge list where the name of the list is the cell population
and the vector in each element contains the parent cell populations of the
named cell population.}

\item{pc__i}{A cell population x marker matrix where the values are 0/1/2/...
correspondng to marker conditions /-/+/...;
this is for the possible CHILD cell populations.}

\item{ac_}{A list where the elements are marker index > "0"/"1"/"2"/... >
a logical vector the same length as the number of cell population phenotypes
indicating whether or not the marker condition exists in them;
this is for the possible PARENT cell populations.}

\item{meta_cell_}{data frame with meta data for cell population phenotypes
from the flowGraph object; this is for the possible PARENT cell populations.}
}
\value{
A list containing parent populations of \code{childs}; also globally
 updates \code{pparen}.
}
\description{
Gets the parent populations of a vector of given cell
 \code{childs} and updates \code{pparen} the edge list if edge list doesn't
 contain the requested information.
}
