% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_gsub_ids}
\alias{fg_gsub_ids}
\title{Replace sample id's.}
\usage{
fg_gsub_ids(fg, ids_new, ids_old = NULL)
}
\arguments{
\item{fg}{flowGraph object.}

\item{ids_new}{A string vector of new sample id's; if \code{ids_old} is
set to \code{NULL}, each id in \code{ids_new} should correspond to
each id in \code{fg_get_meta(fg)$id}.}

\item{ids_old}{A string vector of old sample id's the user wants to replace;
these marker names corresponding to those
in \code{fg_get_meta(fg)$id} with the same length as \code{ids_new}.
If \code{ids_old=NULL}, \code{ids_new} should be the same length as
\code{fg_get_meta(fg)$id}.}
}
\value{
flowGraph object with sample id's replaced.
}
\description{
Replace sample id's in a flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- fg_gsub_ids(fg, ids_new=paste0(fg_get_meta(fg)$id, "_new"))

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_gsub_markers}}
}
