% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_feature_desc}
\alias{fg_get_feature_desc}
\title{Retrieves and/or recalculates a feature description table.}
\usage{
fg_get_feature_desc(fg, re_calc = FALSE)
}
\arguments{
\item{fg}{flowGraph object.}

\item{re_calc}{A logical variable specifying whether or not a feature summary
should be re-calculated or directly retrieved from \code{fg}.}
}
\value{
A data frame where each row contains information on a feature
from the given flowGraph object; its columns is as in the \code{feat_desc}
slot of \code{\link[flowGraph]{flowGraph-class}}.
}
\description{
Retrieves and/or recalculates a feature
 description table for a given flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 fg_get_feature_desc(fg, re_calc=TRUE)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
}
