% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_flowgraph_features.R
\name{fg_feat_cumsum}
\alias{fg_feat_cumsum}
\title{Converts cell counts into cumulated cell counts.}
\usage{
fg_feat_cumsum(fg, no_cores)
}
\arguments{
\item{fg}{flowGraph object.}

\item{no_cores}{An integer indicating how many cores to parallelize on.}
}
\value{
flowGraph object with cumulated counts.
}
\description{
Converts the cell counts in a flowGraph object into
 cumulated cell counts; this is optional and can be done only for there is
 more than one threshold for one or more markers.
 This should also only be ran when initializing a flowGraph object as
 converting back and forth is computationally expensive.
 If the user is interested in seeing non- and cumulated counts, we recommend
 keeping two flowGraph objects, one for each version.
 This function simply converts e.g. the count of A+ or A++ into
 the sum of count of A+, A++, and A+++ or A++, and A+++.
}
\details{
\code{fg_feat_cumsum} returns the given flowGraph object with an
 adjusted count feature. As in our example,
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- flowGraph:::fg_feat_cumsum(fg, no_cores=no_cores)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[Matrix]{Matrix}}
}
